/*
 * Decompiled with CFR 0.152.
 */
package me.theminddroid.drugs.listeners;

import java.util.Arrays;
import java.util.Objects;
import me.theminddroid.drugs.DrugUtilities;
import me.theminddroid.drugs.DrugsPlugin;
import me.theminddroid.drugs.models.Drug;
import me.theminddroid.drugs.states.DrugUsageState;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public class NarcanListener
implements Listener {
    @EventHandler
    public void onDrinkMilk(PlayerItemConsumeEvent event) {
        FileConfiguration messageConfig = ((DrugsPlugin)DrugsPlugin.getPlugin(DrugsPlugin.class)).getConfig();
        if (event.getItem().getType() != Material.MILK_BUCKET) {
            return;
        }
        if (Objects.requireNonNull(event.getItem().getItemMeta()).getDisplayName().equals(ChatColor.RED + "Narcan")) {
            this.useNarcan(event, messageConfig);
            return;
        }
        this.cancelIfPlayerOnDrugs(event, messageConfig);
    }

    private void cancelIfPlayerOnDrugs(PlayerItemConsumeEvent event, FileConfiguration messageConfig) {
        Player player = event.getPlayer();
        if (Arrays.stream(Drug.values()).noneMatch(drug -> DrugUtilities.playerIsOnDrugs(player, drug) || DrugUtilities.playerIsOnDrugWithdrawal(player, drug))) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(Objects.requireNonNull(messageConfig.getString("milkMessage")));
    }

    private void useNarcan(PlayerItemConsumeEvent event, FileConfiguration messageConfig) {
        Player player = event.getPlayer();
        if (!messageConfig.getBoolean("NarcanUse.enabled")) {
            if (messageConfig.getBoolean("drugMessage.enabled")) {
                event.getPlayer().sendMessage(Objects.requireNonNull(messageConfig.getString("drugDisabled")));
            }
            event.setCancelled(true);
            return;
        }
        for (Drug drug : Drug.values()) {
            DrugUsageState drugUsageState = DrugUtilities.getDrugUsage((Metadatable)player, drug);
            if (drugUsageState == null) continue;
            drugUsageState.getWithdrawalTask().cancel();
            player.removeMetadata(DrugUtilities.getPreviousDrugUsageKey(drug), (Plugin)DrugsPlugin.getInstance());
        }
        player.sendMessage(Objects.requireNonNull(messageConfig.getString("consumeNarcan")));
    }
}

